//
//  GSInspectorViewController.h
//  GlyphsCore
//
//  Created by Georg Seifert on 09.02.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

NS_ASSUME_NONNULL_BEGIN

@class GSElement;
@class GSGlyphEditView;
@protocol GSGlyphEditViewControllerProtocol;
@protocol GSGlyphEditViewProtocol;

@interface GSInspectorViewController : NSViewController

@property (weak, nonatomic, nullable) id delegate;
@property (weak, nonatomic, nullable) NSViewController<GSGlyphEditViewControllerProtocol> *controller;

@property (weak, nullable) IBOutlet NSTextField *xField;
@property (weak, nullable) IBOutlet NSTextField *yField;
@property (weak, nullable) IBOutlet NSTextField *nameField;
@property (weak, nullable) NSView<GSGlyphEditViewProtocol> *glyphEditView;

- (IBAction)setXorigin:(nullable id)sender;
- (IBAction)setYorigin:(nullable id)sender;
- (IBAction)setName:(nullable id)sender;
- (void)update;

- (void)setupUIForObjects:(NSArray *)objects key:(NSString *)key target:(NSTextField *)textField format:(NSString *)format;
- (void)setupUIForObjects:(NSArray *)objects key:(NSString *)key target:(NSTextField *)textField format:(NSString *)format precision:(int)precision;
- (void)setPositionFromObjects:(NSArray *)objects;
- (void)setNameFromObjects:(NSArray *)objects;
- (IBAction)showInUnicodeChecker:(nullable id)sender;
- (void)activateEditView;
@end

NS_ASSUME_NONNULL_END
